#include <bits/stdc++.h>
using namespace std;

const int MAXN = 200020;
long long A[MAXN];
long long C[MAXN];
long long pref[MAXN];
unordered_map<long long, int> table;
unordered_map<long long, int> first;
unordered_map<long long, int> last;
unordered_map<long long, bool> visited;
bool eliminated[MAXN];
pair<int, int> brackets[2 * MAXN];

int seg[4 * MAXN];

void update(int i, int l, int r, int index, int dx) {
    if (l == r) {
        seg[i] += dx;
    }
    else {
        int mid = (l + r) / 2;
        if (index <= mid) update(2 * i, l, mid, index, dx);
        else update(2 * i + 1, mid + 1, r, index, dx);
        seg[i] = max(seg[2 * i], seg[2 * i + 1]);
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    int n;
    cin >> n;
    for (int i = 1; i <= n; i++) {
        cin >> A[i];
        C[i] = A[i];
    }   

    for (int i = 1; i <= n; i++) {
        pref[i] = pref[i-1] + A[i];
    }

    for (int i = 1; i <= n; i++) {
        last[pref[i]] = i;
    }
    for (int i = n; i >= 0; i--) {
        first[pref[i]] = i;
    }

    sort(C + 1, C + n + 1);
    for (int i = 1; i <= n; i++) {
        table[C[i]] = i;
    }
    for (int i = 1; i <= n; i++) {
        A[i] = table[A[i]];
    }
    for (int i = 1; i <= n; i++) {
       // cout << A[i] << endl;
    }

    int maxLen = 0;
    vector<pair<int, int>> ans;
    for (int i = 1; i <= n; i++) { 
        long long a = pref[i];
        if (visited[a]) continue;
        visited[a] = true;
        int l = first[a];
        int r = last[a];
        if (l == r) continue;
        int d = (r - l);
        ans.push_back({l + 1, r});
        //cout << l + 1 << ' ' << r <<endl;
    }

    if (ans.empty()) {
        assert(false); //maybe?
        cout << 1 << endl;
        return 0;
    }

    sort(ans.begin(), ans.end());

    for (int i = 0; i < ans.size(); i++) {
        int l = ans[i].first;
        int r = ans[i].second;
        brackets[2 * i] = {l, -(i+1)};
        brackets[2 * i + 1] = {r, i+1};
    }
    sort(brackets, brackets + 2 * ans.size());
    for (int i = 0; i < 2 * ans.size(); i+=2){
     //   cout << brackets[i].second << ' ' << brackets[i+1].second << ' ';
    }
   //cout << endl;

    queue<int> q;
    for (int i = 0; i < 2 * ans.size(); i++) {
        int v = brackets[i].second;
        if (v < 0) {
            q.push(-v);
          //  cout << "ADDED: " << -v << endl;
        }
        else {
            while(eliminated[q.front()]) {
               // cout << "ELIMINATED: " << q.front() << endl;
                q.pop();
            }

            int u = q.front();
            if (u != v) {
                eliminated[v] = true;
                //cout << "WTF: " << v << endl;
            }
            else {
                //cout << "REMOVED: " << u << endl;
                q.pop();
            }
        }
    }


    int segL = 0;
    int segR = 1;
    int ansCnt = 0;
    for (int i = 0; i < ans.size(); i++) {
        if (eliminated[i + 1]) {
            continue;
        }
        int l = ans[i].first;
        int r = ans[i].second;

       // cout << "WTF: " << l << ' ' << r << endl;

        while (segR <= r) {
            update(1, 1, n, A[segR], 1);
            //cout << "ADDED SEG: " << A[segR] << endl;
            segR++;
        }
        while (segL <= l - 1) {
            if (A[segL] != 0)
                update(1, 1, n, A[segL], -1);
            // cout << "REMOVED SEG: " << A[segL] << endl;
            segL++;
        }
        ansCnt = max(ansCnt, seg[1]);
    }
    cout << ansCnt << endl;


    return 0;
}